-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)  
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.conReached = false
    self.pos = self:GetPosition()
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.timer = 4
      self.active = false
    end
    
    self.thallWin:LinkToTarget("victory")
    self.thallDef:LinkToTarget("defeat")
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      CheckForHero(self)
      self.timer = 4
    end
  end
  
  if self.conReached then
    self.thallWin:TriggerAllTargets()
    self.conReached = false
  end
end

function OnBeforeDeath(self)
  self.thallDef:TriggerAllTargets()
end

function CheckForHero(self)
  hero = self.p0:UnitsInRadiusNumberByKey(self.pos, 1500, "hero")
  
  if hero >= 1 then
    self.conReached = true
    self.active = false
  end
end

function OnTrigger(self, source, target)
  if target == "winCondActive" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.timer = ar:Read()
    self.active = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.timer)
    ar:Write(self.active)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("winCondActive")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("thallWin")
  self:AddTriggerSource("thallDef")
end
